//
//  MCConfigClientEndpoint.h
//  MCClientServer
//
//  Created by Michael Clark on 09-09-17.
//  Copyright 2009 Marketcircle, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "MCConfigGlobals.h"

#import <MCNetComm/MCEndpoint.h>


@interface MCConfigClientEndpoint : MCEndpoint
{
	id delegate;
}

- (id)delegate;
- (void)setDelegate:(id)aDelegate;

- (id)initWithHostAddress:(NSString *)hostAddress port:(unsigned short)hostPort;

- (void)authorizeForDO;

@end


@interface NSObject (MCConfigAuthenticationProtocolDelegate)

- (void)clientEndpoint:(MCConfigClientEndpoint *)endpoint authorizationFailedWithResult:(MCCAuthorizationRequestResultType)result;
- (void)clientEndpoint:(MCConfigClientEndpoint *)endpoint authorizationSucceededReturningInfo:(NSDictionary *)infoDict;

@end
